

************************************************************
************************************************************
***      Retrieving Panel Data from the SOEP 1           ***
***   Getting acquainted with the SOEP data sets         ***
***		    Josef Brderl, Volker Ludwig           	     *** 	   
***		            May 2012                             *** 	   
************************************************************
************************************************************

** WARNING: This do-file is not intended for running in one job
**          Work through example by example

* Data: SOEP 1984-2010 v27

* Set system memory and define working directories
clear 
set more off
version 12

global pfad1 `""C:\SOEP\V27\""'        //directory of original data 
global pfad2 `""C:\SOEP\work\""'       //working directory  



**********************************
*** THE PERSON DATA FILES $P *****
**********************************

* Describing the data set
cd $pfad1
use ap.dta, clear
descr

* Listing the data
list ahhnr hhnrakt persnr welle ap57 ap3301 ap62z ap6801 in 1/5, nol
use bp.dta, clear
list bhhnr hhnrakt persnr welle bp85 bp4301 bp81 bp9301 in 1/5, nol



************************************
*** THE PERSON DATA FILE PPFAD *****
************************************

* Describing the data set
cd $pfad1
use ppfad.dta, clear
descr

tab znetto
tab zpop

tab1 sex gebjahr gebmonat          //month of birth unknown for 45%!
tab1 loc1989 gsampreg zsampreg
tab1 germborn migback              //also available: immiyear corigin
tab1 erstbefr letztbef  todjahr
tab1 psample


************************************
*** THE PERSON DATA FILE PGEN  *****
************************************

cd $pfad1
use apgen.dta, clear

descr


*************************************
*** THE PERSON DATA FILE PEQUIV *****
*************************************

cd $pfad1
use apequiv.dta, clear

descr

* Note that varnames can be abbreviated: 
* "84" is ignored, but in a single dataset abbrevations are still unique
tab1 d11104 d11109          //demographics
tab1 l11101 l11102          //East-West 
tab p11101                  //happiness
summ i11102                 //yearly income in EURO after taxes


*************************************
*** THE HOUSEHOLD DATA FILE $HGEN ***
*************************************

cd $pfad1
use zhgen.dta, clear

descr

tab hmode

* HHincome in three variants!
tab hinc if hinc<100
tab ahinc if ahinc<100
tab i1hinc if i1hinc<100


*************************************
*** THE PERSON WEIGHTS PHRF       ***
*************************************

cd $pfad1
use phrf.dta, clear

descr
